<!doctype html>
<html class="no-js" lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">

  <!-- Site Title -->
  <title>ASV</title>

  <!-- Place favicon.ico in the root directory -->
  <link rel="shortcut icon" type="image/x-icon" href="assets/images/fav.png">

  <!-- CSS here -->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/font-awesome-pro.min.css">
  <link rel="stylesheet" href="assets/css/animate.min.css">
  <link rel="stylesheet" href="assets/css/bexon-icons.css">
  <link rel="stylesheet" href="assets/css/nice-select.css">
  <link rel="stylesheet" href="assets/css/swiper.min.css">
  <link rel="stylesheet" href="assets/css/venobox.min.css">
  <link rel="stylesheet" href="assets/css/odometer-theme-default.css">
  <link rel="stylesheet" href="assets/css/meanmenu.css">
  <link rel="stylesheet" href="assets/css/main.css">
</head>

<body>
  <div class="body-overlay"></div>

  <!-- Preloader Start -->
  <div class="preloader">
    <div class="loading-container">
      <div class="loading"></div>
      <div id="loading-icon"><img src="assets/images/logos/logo_loading.png" alt=""></div>
    </div>
  </div>
  <!-- Preloader end -->

  <!-- back to top start -->
  <div class="back-to-top-wrapper">
    <button id="back_to_top" type="button" class="back-to-top-btn">
      <span><i class="tji-arrow-up-long"></i></span>
    </button>
  </div>
  <!-- back to top end -->

  <!-- start: Search Popup --
  <div class="search-popup-overlay"></div>
  <! end: Search Popup -->
	
  <!-- start: Header Area -->
  <?php include("header.php"); 
	?>
  <!-- end: Header Area -->

  <main id="primary" class="site-main">
    <!-- start: Banner Section -->
    <section class="tj-banner-section section-gap-x">
      <div class="banner-area">
        <div class="banner-left-box">
          <div class="banner-content">
            <span class="sub-title wow fadeInDown" data-wow-delay=".2s">
              From Vision to Visible Progress
            </span>
            <h1 class="banner-title title-anim">Guided by Insight, Planning & Performance
            </h1>
            <div class="banner-desc-area wow fadeInUp" data-wow-delay=".7s">
              <a class="banner-link" href="about.php">
                <span><i class="tji-arrow-right-big"></i></span>
              </a>
              <div class="banner-desc">We help businesses move forward with clarity, ensuring that each milestone contributes to long-term success and stability.
              </div>
            </div>
          </div>
          <div class="banner-shape">
            <img src="assets/images/shape/pattern-bg.webp" alt="">
          </div>
        </div>
        <div class="banner-right-box">
          <div class="banner-img">
            <img src="assets/images/hero/hero-img.jpg" alt="">
          </div>
          <div class="box-area">
            <div class="customers-box">

              <div class="customers-number wow fadeInUp" data-wow-delay=".5s">10+</div>
              <h6 class="customers-text wow fadeInUp" data-wow-delay=".5s">Years of Excellence for Empowering Businesses</h6>
            </div>
          </div>
        </div>
      </div>
      <div class="banner-scroll wow fadeInDown" data-wow-delay="2s">
        <a href="#choose" class="scroll-down">
          <span><i class="tji-arrow-down-long"></i></span>
          Scroll Down
        </a>
      </div>
    </section>
    <!-- end: Banner Section -->

    <!-- start: Choose Section --
    <section id="choose" class="tj-choose-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading text-center">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Choose the Best</span>
              <h2 class="sec-title title-anim">Empowering Business with <span>Expertise.</span></h2>
            </div>
          </div>
        </div>
        <div class="row row-gap-4 rightSwipeWrap">
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-innovative"></i>
                </div>
                <h4 class="title">Innovative Solutions</h4>
                <p class="desc">We stay ahead of the curve, leveraging cutting-edge technologies and strategies to keep
                  you competitive in a marketplace.</p>
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-award"></i>
                </div>
                <h4 class="title">Award-Winning Expertise</h4>
                <p class="desc">Recognized by industry leaders, our award-winning team has a proven record of delivering
                  excellence across projects.</p>
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-support"></i>
                </div>
                <h4 class="title">Dedicated Support</h4>
                <p class="desc">Our team is always available to address your concerns, providing quick and effective
                  solution to keep your business.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Choose Section -->

    <!-- start: Client Section -->
    <!--<section class="tj-client-section client-section-gap wow fadeInUp" data-wow-delay=".4s">
      <div class="container-fluid client-container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading style-4 text-center">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s">What We Do</span>
            </div>
            <div class="swiper client-slider client-slider-1">
              <div class="swiper-wrapper">
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-1.webp" alt="">
                  </div>
                </div>
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-2.webp" alt="">
                  </div>
                </div>
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-3.webp" alt="">
                  </div>
                </div>
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-4.webp" alt="">
                  </div>
                </div>
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-5.webp" alt="">
                  </div>
                </div>
                <div class="swiper-slide client-item">
                  <div class="client-logo">
                    <img src="assets/images/brands/brand-6.webp" alt="">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>-->
      <!-- start: Project Section -->
    <section class="tj-project-section-4 section-gap">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading style-4 text-center">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s">What We Do</span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="project-wrapper wow fadeInUp" data-wow-delay=".5s">
              <div class="swiper project-slider-3">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <div class="project-item h4-project-item">
                      <div class="project-content">
                        <div class="project-text">
                          <h4 class="title" style="font-size: 20px"><a href="it.php">Information Technology</a></h4>
                          <a class="tji-icon-btn" href="it.php">
                            <i class="tji-arrow-right-long"></i>
                          </a>
                        </div>
                      </div>
                      <div class="project-img">
                        <img src="assets/images/project/it.jpg" alt="Image">
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="project-item h4-project-item">
                      <div class="project-content">
                        <div class="project-text">
                          <h4 class="title" style="font-size: 20px"><a href="construction.php">Real Estate - Construction</a></h4>
                          <a class="tji-icon-btn" href="construction.php">
                            <i class="tji-arrow-right-long"></i>
                          </a>
                        </div>
                      </div>
                      <div class="project-img">
                        <img src="assets/images/project/construction.jpg" alt="Image">
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="project-item h4-project-item">
                      <div class="project-content">
                        <div class="project-text">
                          <h4 class="title" style="font-size: 20px"><a href="consultation.php">Real Estate - Investment Consultation</a></h4>
                          <a class="tji-icon-btn" href="consultation.php">
                            <i class="tji-arrow-right-long"></i>
                          </a>
                        </div>
                      </div>
                      <div class="project-img">
                        <img src="assets/images/project/investment.jpg" alt="Image">
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="project-item h4-project-item">
                      <div class="project-content">
                        <div class="project-text">
                          <h4 class="title" style="font-size: 20px"><a href="content.php">Real Estate - Advertisement</a></h4>
                          <a class="tji-icon-btn" href="content.php">
                            <i class="tji-arrow-right-long"></i>
                          </a>
                        </div>
                      </div>
                      <div class="project-img">
                        <img src="assets/images/project/content.jpeg" alt="Image">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-pagination-area"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- end: Project Section -->
    <!-- start: Service Section -->
    <!-- end: Service Section -->

    <section class="tj-about-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-xl-6 col-lg-6 order-lg-1 order-2">
            <div class="about-img-area wow fadeInLeft" data-wow-delay=".2s">
              <div class="about-img">
                <img src="assets/images/about/about.jpg" alt="">
              </div>
              <div class="box-area">
                <div class="experience-box wow fadeInUp" data-wow-delay=".3s">
                  <span class="sub-title">Experiences</span>
                  <div class="customers-number">120+</div>
                  <h6 class="customers-text">& counting clients for serving in all across of our services.</h6>
                </div>
              </div>
            </div>
          </div>
          <div class="col-xl-6 col-lg-6 order-lg-2 order-1">
            <div class="about-content-area style-1 wow fadeInLeft" data-wow-delay=".2s">
              <div class="sec-heading">
                <span class="sub-title wow fadeInUp" data-wow-delay=".3s">Who We Are</span>
                <h2 class="sec-title title-anim">Built on Vision, Strengthened by Values
                </h2>
              </div>
              <div class="wow fadeInUp" data-wow-delay=".5s">
                <a class="text-btn" href="about.php">
                  <span class="btn-text"><span>Know More</span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
            <div class="about-bottom-area">
              <div class="client-review-cont wow fadeInUp" data-wow-delay=".7s">
                <p>We operate across multiple sectors—Information Technology, Real Estate Construction, Investment Consultation, and Content Marketing—offering integrated solutions that empower businesses, investors, and brands to grow with confidence.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- end: About Section -->

    <!-- start: Service Section --
    <section class="tj-service-section overflow-hidden section-gap section-gap-x">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading text-center">
              <span class="sub-title text-white wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Our
                Solutions</span>
              <h2 class="sec-title text-white title-anim">Solutions to Transform Your <span>Business.</span></h2>
            </div>
          </div>
        </div>
      </div>
      <div class="container-fluid p-0">
        <div class="row">
          <div class="col-12">
            <div class="service-wrapper wow fadeInUp" data-wow-delay=".4s">
              <div class="swiper service-slider">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <div class="service-item style-1">
                      <div class="service-img">
                        <img src="assets/images/service/service-1.webp" alt="">
                      </div>
                      <div class="service-icon">
                        <i class="tji-service-1"></i>
                      </div>
                      <div class="service-content">
                        <h4 class="title"><a href="service-details.php">Business Strategy Development</a></h4>
                        <p class="desc">Through a combination of data-driven insights and innovative approaches, we work
                          closely with you to develop customized.</p>
                        <a class="text-btn" href="service-details.php">
                          <span class="btn-text"><span>Learn More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="service-item style-1">
                      <div class="service-img">
                        <img src="assets/images/service/service-5.webp" alt="">
                      </div>
                      <div class="service-icon">
                        <i class="tji-service-2"></i>
                      </div>
                      <div class="service-content">
                        <h4 class="title"><a href="service-details.php">Customer Experience Solutions</a></h4>
                        <p class="desc">Developing personalized customer journeys to increase satisfaction and loyalty
                          of our expansion to keep competitive.</p>
                        <a class="text-btn" href="service-details.php">
                          <span class="btn-text"><span>Learn More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="service-item style-1">
                      <div class="service-img">
                        <img src="assets/images/service/service-6.webp" alt="">
                      </div>
                      <div class="service-icon">
                        <i class="tji-service-3"></i>
                      </div>
                      <div class="service-content">
                        <h4 class="title"><a href="service-details.php">Sustainability and ESG Consulting</a></h4>
                        <p class="desc">Provide tailored strategies that not only drive long-term value but also build
                          trust with stakeholders, investors.</p>
                        <a class="text-btn" href="service-details.php">
                          <span class="btn-text"><span>Learn More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="service-item style-1">
                      <div class="service-img">
                        <img src="assets/images/service/service-7.webp" alt="">
                      </div>
                      <div class="service-icon">
                        <i class="tji-service-4"></i>
                      </div>
                      <div class="service-content">
                        <h4 class="title"><a href="service-details.php">Training and Development Programs</a></h4>
                        <p class="desc">Training and Development Programs are designed to empower employees with the
                          skills, knowledge, and tools they need.</p>
                        <a class="text-btn" href="service-details.php">
                          <span class="btn-text"><span>Learn More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-pagination-area white-pagination"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="bg-shape-1">
        <img src="assets/images/shape/pattern-2.svg" alt="">
      </div>
      <div class="bg-shape-2">
        <img src="assets/images/shape/pattern-3.svg" alt="">
      </div>
    </section>
    <!- end: Service Section -->

    <!-- start: Project Section --
    <section class="tj-project-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading-wrap">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Proud Projects</span>
              <div class="heading-wrap-content">
                <div class="sec-heading">
                  <h2 class="sec-title title-anim">Breaking Boundaries, Building <span>Dreams.</span></h2>
                </div>
                <p class="desc wow fadeInUp" data-wow-delay=".5s">We work closely with our clients to understand their
                  unique needs and craft tailored
                  solutions that address challenges.</p>
                <div class="btn-wrap wow fadeInUp" data-wow-delay=".6s">
                  <a class="tj-primary-btn" href="portfolio.php">
                    <span class="btn-text"><span>More Projects</span></span>
                    <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="project-area">
              <div class="project-item wow fadeInLeft" data-wow-delay=".3s">
                <div class="project-img" data-bg-image="assets/images/project/project-1.webp"></div>
                <div class="project-content">
                  <span class="categories"><a href="portfolio-details.php">Connect</a></span>
                  <div class="project-text">
                    <h4 class="title"><a href="portfolio-details.php">Event Management Platform</a></h4>
                    <a class="project-btn" href="portfolio-details.php">
                      <i class="tji-arrow-right-long"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="project-item wow fadeInRight" data-wow-delay=".3s">
                <div class="project-img" data-bg-image="assets/images/project/project-2.webp"></div>
                <div class="project-content">
                  <span class="categories"><a href="portfolio-details.php">Empower</a></span>
                  <div class="project-text">
                    <h4 class="title"><a href="portfolio-details.php">Digital Marketing Campaign</a></h4>
                    <a class="project-btn" href="portfolio-details.php">
                      <i class="tji-arrow-right-long"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="project-item wow fadeInLeft" data-wow-delay=".3s">
                <div class="project-img" data-bg-image="assets/images/project/project-3.webp"></div>
                <div class="project-content">
                  <span class="categories"><a href="portfolio-details.php">Support</a></span>
                  <div class="project-text">
                    <h4 class="title"><a href="portfolio-details.php">Interactive Learning Platform</a></h4>
                    <a class="project-btn" href="portfolio-details.php">
                      <i class="tji-arrow-right-long"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="project-item wow fadeInRight" data-wow-delay=".3s">
                <div class="project-img" data-bg-image="assets/images/project/project-4.webp"></div>
                <div class="project-content">
                  <span class="categories"><a href="portfolio-details.php">Business</a></span>
                  <div class="project-text">
                    <h4 class="title"><a href="portfolio-details.php">Environmental Impact Dashboard</a></h4>
                    <a class="project-btn" href="portfolio-details.php">
                      <i class="tji-arrow-right-long"></i>
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Project Section -->

    <!-- start: Countup Section --
    <section class="tj-countup-section">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="countup-wrap">
              <div class="countup-item">
                <div class="inline-content">
                  <span class="odometer countup-number" data-count="93"></span>
                  <span class="count-plus">%</span>
                </div>
                <span class="count-text">Projects Completed.</span>
                <span class="count-separator" data-bg-image="assets/images/shape/separator.svg"></span>
              </div>
              <div class="countup-item">
                <div class="inline-content">
                  <span class="odometer countup-number" data-count="20"></span>
                  <span class="count-plus">M</span>
                </div>
                <span class="count-text">Reach Worldwide</span>
                <span class="count-separator" data-bg-image="assets/images/shape/separator.svg"></span>
              </div>
              <div class="countup-item">
                <div class="inline-content">
                  <span class="odometer countup-number" data-count="8.5"></span>
                  <span class="count-plus">X</span>
                </div>
                <span class="count-text">Faster Growth</span>
                <span class="count-separator" data-bg-image="assets/images/shape/separator.svg"></span>
              </div>
              <div class="countup-item">
                <div class="inline-content">
                  <span class="odometer countup-number" data-count="100"></span>
                  <span class="count-plus">+</span>
                </div>
                <span class="count-text">Awards Archived</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Countup Section -->

    <!-- start: Testimonial Section --
    <section class="tj-testimonial-section section-gap section-gap-x">
      <div class="container">
        <div class="row justify-content-between">
          <div class="col-12">
            <div class="sec-heading-wrap">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Clients Feedback</span>
              <div class="heading-wrap-content">
                <div class="sec-heading">
                  <h2 class="sec-title title-anim">Success <span>Stories</span> Fuel our Innovation.</h2>
                </div>
                <div class="slider-navigation d-inline-flex wow fadeInUp" data-wow-delay=".4s">
                  <div class="slider-prev">
                    <span class="anim-icon">
                      <i class="tji-arrow-left"></i>
                      <i class="tji-arrow-left"></i>
                    </span>
                  </div>
                  <div class="slider-next">
                    <span class="anim-icon">
                      <i class="tji-arrow-right"></i>
                      <i class="tji-arrow-right"></i>
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="testimonial-wrapper wow fadeInUp" data-wow-delay=".5s">
              <div class="swiper swiper-container testimonial-slider">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>Working with Bexon has been a game-changer for our business. Their team's professionalism,
                          attention to detail, and innovative solutions have helped us streamline operations and achieve
                          our goals faster than we imagined. We truly feel like a valued partner.</p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-1.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Guy Hawkins</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>The results we’ve seen after partnering with Bexon are beyond our expectations. They not only
                          understood our vision but also brought new ideas to the table that have taken our business to
                          the next level. Their expertise and commitment to success make them a trusted.
                        </p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-2.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Ralph Edwards</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>We’ve been working with Bexonfor years, and they continue to deliver outstanding results.
                          Their team is proactive, responsive, and always goes the extra mile to ensure our needs are
                          met. They’ve become a key contributor to our growth and success that really help us"
                        </p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-3.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Devon Lane</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-pagination-area"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="bg-shape-1">
        <img src="assets/images/shape/pattern-2.svg" alt="">
      </div>
      <div class="bg-shape-2">
        <img src="assets/images/shape/pattern-3.svg" alt="">
      </div>
    </section>
    <!- end: Testimonial Section -->

    <!-- start: Faq Section -->
    <section class="tj-faq-section section-gap">
      <div class="container">
        <div class="row justify-content-between">
          <div class="col-lg-6">
            <div class="faq-img-area wow fadeInLeft" data-wow-delay=".3s">
              <div class="faq-img">
                <img src="assets/images/faq/faq.jpg" alt="">
              </div>
              <div class="box-area">
                <div class="call-box wow fadeInUp" data-wow-delay=".4s">
                  <h4 class="title">FAQ</h4>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="accordion tj-faq" id="faqOne">
              
              <div class="accordion-item wow fadeInUp" data-wow-delay=".3s">
                <button class="faq-title collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-2"
                  aria-expanded="false">What Information & Technology services do you provide?</button>
                <div id="faq-2" class="collapse" data-bs-parent="#faqOne">
                  <div class="accordion-body faq-text">
                    <p style="text-align: justify;">We deliver scalable IT solutions including software development, digital systems integration, and technology support designed to improve efficiency and business performance.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-item wow fadeInUp" data-wow-delay=".3s">
                <button class="faq-title collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-3"
                  aria-expanded="false">How does your property investment consultation work?</button>
                <div id="faq-3" class="collapse" data-bs-parent="#faqOne">
                  <div class="accordion-body faq-text">
                    <p style="text-align: justify;">We offer strategic guidance based on market analysis, location insights, and risk evaluation to support informed property investment decisions.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-item wow fadeInUp" data-wow-delay=".3s">
                <button class="faq-title collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-4"
                  aria-expanded="false">Do you handle both residential and commercial construction?</button>
                <div id="faq-4" class="collapse" data-bs-parent="#faqOne">
                  <div class="accordion-body faq-text">
                    <p>Yes, we manage residential and commercial construction projects with a focus on quality, compliance, and timely execution.</p>
                  </div>
                </div>
              </div>
              <div class="accordion-item wow fadeInUp" data-wow-delay=".3s">
                <button class="faq-title collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-5"
                  aria-expanded="false">How do you support property marketing through content?</button>
                <div id="faq-5" class="collapse" data-bs-parent="#faqOne">
                  <div class="accordion-body faq-text">
                    <p>We create property-focused digital content including visuals, videos, and promotional campaigns that enhance visibility and buyer engagement.</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- end: Faq Section -->

    <!-- start: Contact Section --
    <section class="tj-contact-section section-gap section-gap-x">
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <div class="global-map wow fadeInUp" data-wow-delay=".3s">
              <div class="global-map-img" data-bg-image="assets/images/bg/map-2.svg"></div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="contact-form style-2 wow fadeInUp" data-wow-delay=".4s">
              <div class="sec-heading">
                <span class="sub-title text-white"><i class="tji-box"></i>Get in Touch</span>
                <h2 class="sec-title title-anim">Drop Us a <span>Line.</span></h2>
              </div>
              <form id="contact-form-2">
                <div class="row wow fadeInUp" data-wow-delay=".5s">
                  <div class="col-sm-6">
                    <div class="form-input">
                      <input type="text" name="cfName2" placeholder="Full Name *">
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-input">
                      <input type="email" name="cfEmail2" placeholder="Email Address *">
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-input">
                      <input type="tel" name="cfPhone2" placeholder="Phone number *">
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-input">
                      <div class="tj-nice-select-box">
                        <div class="tj-select">
                          <select name="cfSubject2">
                            <option value="0">Chose a option</option>
                            <option value="1">Business Strategy</option>
                            <option value="2">Customer Experience</option>
                            <option value="3">Sustainability and ESG</option>
                            <option value="4">Training and Development</option>
                            <option value="5">IT Support & Maintenance</option>
                            <option value="6">Marketing Strategy</option>
                          </select>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12">
                    <div class="form-input message-input">
                      <textarea name="cfMessage2" id="message" placeholder="Type message *"></textarea>
                    </div>
                  </div>
                  <div class="submit-btn">
                    <button class="tj-primary-btn" type="submit">
                      <span class="btn-text"><span>Send Message</span></span>
                      <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
      <div class="bg-shape-1">
        <img src="assets/images/shape/pattern-2.svg" alt="">
      </div>
      <div class="bg-shape-2">
        <img src="assets/images/shape/pattern-3.svg" alt="">
      </div>
    </section>
    <!- end: Contact Section -->
        <!-- start: Blog Section -->
    <!-- <section class="tj-blog-section-2 section-gap">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading-wrap">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s">Recent Case Studies</span>
              <--<div class="heading-wrap-content">
                <div class="sec-heading style-2">
                  <h2 class="sec-title text-anim">Strategies and <span>Insights.</span></h2>
                </div>
                <div class="wow fadeInUp" data-wow-delay=".5s">
                  <p class="desc">Developing personalized customer journeys to increase satisfaction and loyalty.</p>
                </div>
                <div class="slider-navigation d-none d-md-inline-flex wow fadeInUp" data-wow-delay=".7s">
                  <div class="slider-prev">
                    <span class="anim-icon">
                      <i class="tji-arrow-left"></i>
                      <i class="tji-arrow-left"></i>
                    </span>
                  </div>
                  <div class="slider-next">
                    <span class="anim-icon">
                      <i class="tji-arrow-right"></i>
                      <i class="tji-arrow-right"></i>
                    </span>
                  </div>
                </div>
              </div>--
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="blog-wrapper wow fadeIn" data-wow-delay=".5s">
              <div class="swiper blog-slider">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <div class="blog-item style-2">
                      <div class="blog-thumb">
                        <a href="blog-details.html"><img src="assets/images/blog/blog-4.webp" alt=""></a>
                        <div class="blog-date">
                          <span class="date">28</span>
                          <span class="month">Feb</span>
                        </div>
                      </div>
                      <div class="blog-content">
                        <div class="title-area">
                          <div class="blog-meta">
                            <span class="categories"><a href="blog-details.html">Business</a></span>
                            <span>By <a href="blog-details.html">Ellinien Loma</a></span>
                          </div>
                          <h4 class="title"><a href="blog-details.html">Harnessing Digital Transform a Roadmap
                              Businesses.</a></h4>
                        </div>
                        <a class="text-btn" href="blog-details.html">
                          <span class="btn-text"><span>Read More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="blog-item style-2">
                      <div class="blog-thumb">
                        <a href="blog-details.html"><img src="assets/images/blog/blog-5.webp" alt=""></a>
                        <div class="blog-date">
                          <span class="date">28</span>
                          <span class="month">Feb</span>
                        </div>
                      </div>
                      <div class="blog-content">
                        <div class="title-area">
                          <div class="blog-meta">
                            <span class="categories"><a href="blog-details.html">Business</a></span>
                            <span>By <a href="blog-details.html">Ellinien Loma</a></span>
                          </div>
                          <h4 class="title"><a href="blog-details.html">Mastering Change Management Lessons for
                              Businesses.</a></h4>
                        </div>
                        <a class="text-btn" href="blog-details.html">
                          <span class="btn-text"><span>Read More</span></span>
                          <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-pagination-area"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    end: Blog Section -->


    <!-- start: Blog Section --
    <section class="tj-blog-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading text-center">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Insights & Ideas</span>
              <h2 class="sec-title title-anim">The Ultimate <span>Resource.</span></h2>
            </div>
          </div>
        </div>
        <div class="row row-gap-4">
          <div class="col-xl-4 col-md-6">
            <div class="blog-item wow fadeInUp" data-wow-delay=".4s">
              <div class="blog-thumb">
                <a href="blog-details.php"><img src="assets/images/blog/blog-1.webp" alt=""></a>
                <div class="blog-date">
                  <span class="date">28</span>
                  <span class="month">Feb</span>
                </div>
              </div>
              <div class="blog-content">
                <div class="blog-meta">
                  <span class="categories"><a href="blog-details.php">Business</a></span>
                  <span>By <a href="blog-details.php">Ellinien Loma</a></span>
                </div>
                <h4 class="title"><a href="blog-details.php">Innovative Solutions for every Business Success.</a></h4>
                <a class="text-btn" href="blog-details.php">
                  <span class="btn-text"><span>Read More</span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
          </div>
          <div class="col-xl-4 col-md-6">
            <div class="blog-item wow fadeInUp" data-wow-delay=".4s">
              <div class="blog-thumb">
                <a href="blog-details.php"><img src="assets/images/blog/blog-2.webp" alt=""></a>
                <div class="blog-date">
                  <span class="date">28</span>
                  <span class="month">Feb</span>
                </div>
              </div>
              <div class="blog-content">
                <div class="blog-meta">
                  <span class="categories"><a href="blog-details.php">Business</a></span>
                  <span>By <a href="blog-details.php">Ellinien Loma</a></span>
                </div>
                <h4 class="title"><a href="blog-details.php">Harnessing Digital Transform a Roadmap Businesses.</a>
                </h4>
                <a class="text-btn" href="blog-details.php">
                  <span class="btn-text"><span>Read More</span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
          </div>
          <div class="col-xl-4 col-md-6">
            <div class="blog-item wow fadeInUp" data-wow-delay=".4s">
              <div class="blog-thumb">
                <a href="blog-details.php"><img src="assets/images/blog/blog-3.webp" alt=""></a>
                <div class="blog-date">
                  <span class="date">28</span>
                  <span class="month">Feb</span>
                </div>
              </div>
              <div class="blog-content">
                <div class="blog-meta">
                  <span class="categories"><a href="blog-details.php">Business</a></span>
                  <span>By <a href="blog-details.php">Ellinien Loma</a></span>
                </div>
                <h4 class="title"><a href="blog-details.php">Mastering Change Management Lessons for Businesses.</a>
                </h4>
                <a class="text-btn" href="blog-details.php">
                  <span class="btn-text"><span>Read More</span></span>
                  <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>-->
    <!-- end: Blog Section -->

    <!-- start: Cta Section --
    <section class="tj-cta-section">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="cta-area">
              <div class="cta-content">
                <h2 class="title title-anim">Let’s Build Future Together.</h2>
                <div class="cta-btn wow fadeInUp" data-wow-delay=".6s">
                  <a class="tj-primary-btn btn-dark" href="contact.php">
                    <span class="btn-text"><span>Get Started Now</span></span>
                    <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                  </a>
                </div>
              </div>
              <div class="cta-img">
                <img src="assets/images/cta/cta-bg.webp" alt="">
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Cta Section -->
  </main>

  <!-- start: Footer Section -->
  <?php include("footer.php"); 
	?>
  <!-- end: Footer Section -->

  <!-- JS here -->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/js/gsap.min.js"></script>
  <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
  <script src="assets/js/gsap-scroll-trigger.min.js"></script>
  <script src="assets/js/gsap-split-text.min.js"></script>
  <script src="assets/js/smooth-scroll.min.js"></script>

  <script src="assets/js/jquery.nice-select.min.js"></script>
  <script src="assets/js/swiper.min.js"></script>
  <script src="assets/js/odometer.min.js"></script>
  <script src="assets/js/venobox.min.js"></script>
  <script src="assets/js/appear.min.js"></script>
  <script src="assets/js/wow.min.js"></script>
  <script src="assets/js/meanmenu.js"></script>
  <script src="assets/js/main.js"></script>
</body>
</html>